/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import panther.util.general.DevOut;
import panther.util.unicon.NodeToString;

public class DOMPrinter {
    protected Node doc;

    public DOMPrinter(Node node) {
        this.doc = node;
    }

    public static String nodeString(Node node) {
        return new DOMPrinter(node).toString();
    }

    public static String toString(Node node, boolean bl) {
        NodeToString nodeToString = new NodeToString(node);
        nodeToString.setPrintTopLevelTag(bl);
        nodeToString.setPrintNewLines(false);
        return nodeToString.toString();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            this.print(this.doc, stringWriter);
        }
        catch (Exception exception) {
            DevOut.trace(exception);
        }
        return ((Object)stringWriter).toString();
    }

    public void print(Node node, Writer writer) throws IOException {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 9: {
                this.print(((Document)node).getDocumentElement(), writer);
                break;
            }
            case 1: {
                writer.write(60);
                writer.write(node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Node node2 = namedNodeMap.item(i);
                    writer.write(32);
                    writer.write(node2.getNodeName());
                    writer.write("=\"");
                    this.canonicalize(node2.getNodeValue(), writer);
                    writer.write(34);
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList.getLength() == 0) {
                    writer.write("/>");
                    break;
                }
                writer.write(">");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this.print(nodeList.item(i), writer);
                }
                writer.write("</");
                writer.write(node.getNodeName());
                writer.write(">");
                break;
            }
            case 5: {
                writer.write(38);
                writer.write(node.getNodeName());
                writer.write(59);
                break;
            }
            case 4: {
                this.canonicalize(node.getNodeValue(), writer);
                break;
            }
            case 3: {
                this.canonicalize(node.getNodeValue(), writer);
            }
        }
    }

    protected void canonicalize(String string, Writer writer) throws IOException {
        if (string == null) {
            return;
        }
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    writer.write("&lt;");
                    continue block6;
                }
                case '>': {
                    writer.write("&gt;");
                    continue block6;
                }
                case '&': {
                    writer.write("&amp;");
                    continue block6;
                }
                case '\"': {
                    writer.write("&quot;");
                    continue block6;
                }
                default: {
                    writer.write(c);
                }
            }
        }
    }
}

